/** Example how to create OMP aware code.
 */
#include "image.h"

#include <stdio.h>


int main(void)
{
Image Img;
RGBQuad Color1, Color2;

  Color1.R = Color1.G = Color1.B = 0;
  Color2.R = Color2.G = Color2.B = 255;

  Img.AttachRaster(CreateRaster2DRGB(2048,2048,8));
  if(Img.Raster==NULL) return -1;

#pragma omp parallel
  {
    Raster1DAbstract * const RasRGBrow = CreateRaster1DRGB(0,Img.Raster->GetPlanes()/Img.Raster->Channels());

    RasRGBrow->Shadow = true;
    RasRGBrow->Size1D = Img.Raster->Size1D;

#pragma omp  for ordered schedule(dynamic)
    for(int y=0; y<Img.Raster->Size2D; y++)
    {
      RasRGBrow->Data1D = Img.Raster->GetRow(y);
      for(int x=0; x<Img.Raster->Size1D; x++)
      {
        if((x-900)*(x-900)+(y-900)*(y-900) < 40000)
          RasRGBrow->Set(x,&Color1);
        else
          RasRGBrow->Set(x,&Color2);
      }
    }

    delete RasRGBrow;
  }

 return SavePicture("test4.bmp",Img);
}